<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <!-- Variable to hold unit string -->
    <xsl:variable name="unit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'"> st</xsl:when>
            <xsl:otherwise> m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Horizontal Alignment Legal Description from Reference -->
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads">
                    <xsl:text/>
                    <xsl:text>             Popis Směrové řešení z reference&#xd;</xsl:text>
                    <xsl:text>                      Datum výpisu:  </xsl:text><xsl:value-of select="cif:date()"/><xsl:text> &#xa0;</xsl:text>
                    <xsl:value-of select="cif:time()"/><xsl:text>&#xd;&#xd;</xsl:text>
                    <xsl:for-each select="GeometryProject">
                        <xsl:text>              Projekt:  </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>                Popis:  </xsl:text><xsl:value-of select="@description"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>      Koficient rastr:  </xsl:text><xsl:value-of select="../@inputGridScaleFactor"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>--------------------------------------------------------------------------------&#xd;</xsl:text>
                        <xsl:for-each select="HorizontalAlignment">
                            <xsl:text>          Trasa Název:  </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                            <xsl:text>          Trasa Popis:  </xsl:text><xsl:value-of select="@description"/><xsl:text>&#xd;</xsl:text>
                            <xsl:text>     Referenční trasa:  </xsl:text><xsl:value-of select="//legalReference/@referenceAlignment"/><xsl:text>&#xd;&#xd;</xsl:text>
                            <xsl:apply-templates select="HorizontalElements/HorizontalLine | HorizontalElements/HorizontalCircle | HorizontalElements/HorizontalSpiral"/>
                            <xsl:if test="@area &gt; 0">
                                <xsl:text>a POČÁTEČNÍ BOD.&#xd;&#xd;</xsl:text>
                                <xsl:text>Popisovaná parcela má plochu  </xsl:text>
                                <xsl:if test="//@linearUnits = 'Imperial'">
                                    <xsl:value-of select="cif:acreFormat(number(@area) div 43560)"/><xsl:text> akrů (</xsl:text>
                                    <xsl:value-of select="cif:acreFormat(number(@area))"/><xsl:text> st2)&#xd;&#xd;&#xd;</xsl:text>
                                </xsl:if>
                                <xsl:if test="//@linearUnits = 'Metric'">
                                    <xsl:value-of select="cif:acreFormat(number(@area) div 10000)"/><xsl:text> hetarů (</xsl:text>
                                    <xsl:value-of select="cif:acreFormat(number(@area))"/><xsl:text> m2)&#xd;&#xd;&#xd;</xsl:text>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Line -->
    <xsl:template match="HorizontalLine">
        <xsl:if test="position() = 1">
            <xsl:text>Začíná v </xsl:text>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="Start/@name"/><xsl:text>,&#xd;</xsl:text>
                </xsl:when>
                <xsl:otherwise><xsl:text>bodě,&#xd;</xsl:text></xsl:otherwise>
            </xsl:choose>
            <xsl:text> tento bod je POČÁTEČNÍ BOD;&#xd;</xsl:text>
        </xsl:if>
        <xsl:text>odtud </xsl:text>
        <xsl:value-of select="cif:directionFormat(number(@direction))"/>
        <xsl:text>, </xsl:text>
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        <xsl:value-of select="$unit"/>
        <xsl:choose>
            <xsl:when test="End/@name">
                <xsl:text> k bodu </xsl:text><xsl:value-of select="End/@name"/><xsl:text>&#xd;</xsl:text>
            </xsl:when>
            <xsl:otherwise><xsl:text>&#xd;</xsl:text></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Circle -->
    <xsl:template match="HorizontalCircle">
        <xsl:if test="position() = 1">
            <xsl:text>Začíná v </xsl:text>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="Start/@name"/><xsl:text>,&#xd;</xsl:text>
                </xsl:when>
                <xsl:otherwise><xsl:text>bodě,&#xd;</xsl:text></xsl:otherwise>
            </xsl:choose>
            <xsl:text> tento bod je POČÁTEČNÍ BOD;&#xd;</xsl:text>
        </xsl:if>
        <xsl:text>odtud podél oblouku </xsl:text>
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        <xsl:value-of select="$unit"/>
        <xsl:if test="Start/legalReference/@offset &gt;= 0"><xsl:text> doprava</xsl:text></xsl:if>
        <xsl:if test="Start/legalReference/@offset &lt; 0"><xsl:text> doleva</xsl:text></xsl:if>
        <xsl:text>, o poloměru&#xd;</xsl:text>
        <xsl:text> </xsl:text><xsl:value-of select="cif:distanceFormat(number(@radius))"/>
        <xsl:value-of select="$unit"/><xsl:text> s tětivou &#xd;</xsl:text>
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
        <xsl:text>, </xsl:text>
        <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
        <xsl:value-of select="$unit"/>
        <xsl:choose>
            <xsl:when test="End/@name">
                <xsl:text> k bodu </xsl:text><xsl:value-of select="End/@name"/><xsl:text>&#xd;</xsl:text>
            </xsl:when>
            <xsl:otherwise><xsl:text>&#xd;</xsl:text></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Spiral -->
    <xsl:template match="HorizontalSpiral">
        <xsl:if test="position() = 1">
            <xsl:text>Začíná v </xsl:text>
            <xsl:choose>
                <xsl:when test="Start/@name">
                    <xsl:value-of select="Start/@name"/><xsl:text>,&#xd;</xsl:text>
                </xsl:when>
                <xsl:otherwise><xsl:text>bodě,&#xd;</xsl:text></xsl:otherwise>
            </xsl:choose>
            <xsl:text> tento bod je POČÁTEČNÍ BOD;&#xd;</xsl:text>
        </xsl:if>
        <xsl:text>odtud podél přechodnice </xsl:text>
        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
        <xsl:value-of select="$unit"/>
        <xsl:if test="Start/legalReference/@offset &gt;= 0"><xsl:text> doprava</xsl:text></xsl:if>
        <xsl:if test="Start/legalReference/@offset &lt; 0"><xsl:text> doleva</xsl:text></xsl:if>
        <xsl:text>, s tětivou &#xd;</xsl:text>
        <xsl:text> </xsl:text>
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
        <xsl:text>, </xsl:text>
        <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
        <xsl:value-of select="$unit"/>
        <xsl:choose>
            <xsl:when test="End/@name">
                <xsl:text> do bodu </xsl:text><xsl:value-of select="End/@name"/><xsl:text>&#xd;</xsl:text>
            </xsl:when>
            <xsl:otherwise><xsl:text>&#xd;</xsl:text></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>    Pro tento výpis musíte vybrat nejméně jedno směrové řešení v poli&#xd;</xsl:text>
        <xsl:text>    Zahrnout v Nástroje &gt; XML Výpisy &gt; Uzavřené prvky&#xd;</xsl:text>
        <xsl:text>    nebo Nástroje &gt; XML Výpisy &gt;Geometrie.&#xd;&#xd;</xsl:text>

        <xsl:text>    Pro kompetní výpis je potřeba zadat referenční trasu &#xd;</xsl:text>
        <xsl:text>    v Referenční trasy &gt;, v poli Zahrnout&#xd;</xsl:text>
        <xsl:text>    v Nástroje &gt; XML Výpisy &gt; Uzavřené prvky.&#xd;&#xd;</xsl:text>
		
        <xsl:text>    Pro kompletní výpis jsou vyžadovány pojmenované body směrového řešení.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2006 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
